% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.r
\name{cimis_data}
\alias{cimis_data}
\title{Query CIMIS Data}
\usage{
cimis_data(
  targets,
  start.date,
  end.date,
  items,
  measure.unit = c("E", "M"),
  prioritize.SCS = TRUE
)
}
\arguments{
\item{targets}{geographies or weather stations of interest. This
parameter may specify one or many stations, zip codes,
coordinates, or street addresses; however, you are not allowed to
mix values from different categories. This means the targets
parameter must contain only stations, only zip codes, only
coordinates, or only street addresses. You will receive an error
if you attempt to mix different category types. The formats are
accepted:
\itemize{
\item A comma delimited list of WSN station numbers
\item A comma delimited list of California zip codes
\item A semicolon delimited list of decimal - degree coordinates
\item A semicolon delimited list of street addresses
}}

\item{start.date}{Specifies the start date. The data format is
\code{"yyyy-mm-dd"}.}

\item{end.date}{Specifies the end date. The data format is
\code{"yyyy-mm-dd"}.}

\item{items}{specifies one or more comma-delimited data elements to
include in your response. See \code{data_items()} for a complete list
of possible data element values. Default: day-asce-eto,
day-precip, day-sol-rad-avg, day-vap-pres-avg, day-air-tmp-max,
day-air-tmp-min, day-air-tmp-avg, day-rel-hum-max,
day-rel-hum-min, day-rel-hum-avg, day-dew-pnt, day-wind-spd-avg,
day-wind-run, day-soil-tmp-avg.}

\item{measure.unit}{The unit of measure may be either \code{"E"} for
English units or \code{"M"} for metric units. The value of this
parameter will affect data values in the response. For
example, designating English units will result in temperature
values being returned in Fahrenheit rather than Celsius.}

\item{prioritize.SCS}{This parameter is relevant only when the
targets parameter contains zip code(s). If \code{TRUE}, the Spatial
CIMIS System (SCS) will be used as the preferred data provider.}
}
\value{
A \code{tibble} object.
}
\description{
Query CIMIS data using the Web API.
}
\examples{
if(is_key_set()) {
  cimis_data(targets = 170, start.date = Sys.Date() - 4,
    end.date = Sys.Date() - 1)
}

}
