% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_time_to_event.R
\name{extract_time_to_event}
\alias{extract_time_to_event}
\title{Extract per-stratum event times from a formula and data}
\usage{
extract_time_to_event(
  formula,
  data,
  subset.condition = NULL,
  na.action = na.omit,
  which.event = c("event2", "event1", "censor", "censoring", "user_specified"),
  code.event1 = 1,
  code.event2 = 2,
  code.censoring = 0,
  code.user.specified = NULL,
  read.unique.time = TRUE,
  drop.empty = TRUE
)
}
\arguments{
\item{formula}{A model formula specifying the outcome and (optionally) \code{strata()}.}

\item{data}{A data frame containing variables in \code{formula}.}

\item{subset.condition}{Optional expression (as a character string) defining a
subset of \code{data} to analyse. Defaults to \code{NULL}.}

\item{na.action}{Function to handle missing values (default: \code{na.omit} in \pkg{stats}).}

\item{which.event}{One of \code{"event1"}, \code{"event2"}, \code{"censor"},
\code{"censoring"}, or \code{"user_specified"}, indicating which event type
to extract times for.}

\item{code.event1, code.event2, code.censoring}{Integer codes representing the
event and censoring categories. Defaults are \code{1}, \code{2}, and
\code{0}, respectively.}

\item{code.user.specified}{When \code{which.event = "user_specified"},
the integer event code to extract (e.g., 3 for an intercurrent event).}

\item{read.unique.time}{Logical if \code{TRUE}, only unique and sorted time points
are returned for each stratum.}

\item{drop.empty}{Logical if \code{TRUE} (default), strata with no events are
dropped from the returned list. Set to \code{FALSE} to retain empty strata
as \code{numeric(0)} vectors (useful for diagnostics or consistent list length).}
}
\value{
A named list of numeric vectors, where each element corresponds to a stratum
and contains the event times of the selected type.
}
\description{
Creates a list of event times that can be passed to downstream
visualization or analysis functions such as \code{competing.risk.time} or
\code{intercurrent.event.time} in \code{\link[=cifplot]{cifplot()}} and \code{\link[=cifpanel]{cifpanel()}}.
Event types are specified by event 1, event 2, censoring, or user-specified codes.
}
\details{
This function is typically used internally by plotting and model functions,
but can also be called directly to inspect the per-stratum event-time
structure of a data frame.
}
\section{Lifecycle}{

\lifecycle{stable}
}

\examples{
data(diabetes.complications)
output <- extract_time_to_event(Event(t,epsilon) ~ fruitq,
                                data = diabetes.complications,
                                which.event = "event2")
cifplot(Event(t,epsilon) ~ fruitq,
        data = diabetes.complications,
        outcome.type="competing-risk",
        add.conf=FALSE,
        add.risktable=FALSE,
        add.censor.mark=FALSE,
        add.competing.risk.mark=TRUE,
        competing.risk.time=output,
        label.y="CIF of diabetic retinopathy",
        label.x="Years from registration")
}
\seealso{
\code{\link[=polyreg]{polyreg()}} for log-odds product modeling of CIFs; \code{\link[=cifcurve]{cifcurve()}} for KM/AJ estimators; \code{\link[=cifplot]{cifplot()}} for display of a CIF; \code{\link[=cifpanel]{cifpanel()}} for display of multiple CIFs; \link[ggsurvfit:ggsurvfit]{ggsurvfit::ggsurvfit}, \link[patchwork:patchwork-package]{patchwork::patchwork} and \link[modelsummary:modelsummary]{modelsummary::modelsummary} for display helpers.
}
