% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutilate.R
\name{MutilateGraph}
\alias{MutilateGraph}
\title{Mutilate graph}
\usage{
MutilateGraph(grain_object, intervention)
}
\arguments{
\item{grain_object}{A grain object.}

\item{intervention}{A list of nodes and their corresponding intervention
distribution represented as a vector of unconditional probabilities.}
}
\value{
A grain object.
}
\description{
Mutilate a graph in accordance with an intervention. This is typically used
to perform a do-operation on a given graph. Please note that any evidence
set within the original grain object will not be passed to the new object.
}
\examples{
# This creates a mutilated graph in accordance with turning the sprinkler 
# on in the wet grass example (i.e, do(S = 'yes')).
yn <- c("yes", "no")
p.R <- gRain::cptable(~R, values=c(.2, .8), levels=yn)
p.S_R <- gRain::cptable(~S:R, values=c(.01, .99, .4, .6), levels=yn)
p.G_SR <- gRain::cptable(~G:S:R, values=c(.99, .01, .8, .2, .9, .1, 0, 1), levels=yn)
wet.cpt <- gRain::grain(gRain::compileCPT(p.R, p.S_R, p.G_SR))

mut_graph <- MutilateGraph(wet.cpt, list(S = c(1.0, 0.0)))

# You can then use querygrain to perform an intervention query. For example,
# p(G | do(S = 'yes')) is given by,
gRain::querygrain(mut_graph, 'G')

# You can also perform an observational query for a node not affected
# by the intervention. For example, p(R | do(S = 'yes')) is given by,
gRain::querygrain(mut_graph, 'R')

}
