% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zap_log.R
\name{zap_log}
\alias{zap_log}
\title{Zap the log of a chronicle object}
\usage{
zap_log(.c)
}
\arguments{
\item{.c}{A \code{chronicle} object.}
}
\value{
A new \code{chronicle} object with the same \code{value} as the input, but with
its \code{log_df} replaced by a single entry.
}
\description{
This function replaces the entire existing log of a \code{chronicle} object with a
single, new entry. This new entry simply records that the log was "zapped"
and the time at which it occurred.

This is useful for simplifying a \code{chronicle} object before saving or sharing,
or to mark a definitive checkpoint in a workflow, effectively discarding the
previous history. The underlying \code{value} of the object remains completely
unchanged.
}
\examples{
library(dplyr)

# 1. Create a chronicle object with a multi-step log
r_select <- record(select)
r_filter <- record(filter)

original_chronicle <- starwars \%>\%
  r_select(name, height, mass, species) \%>\%
  bind_record(r_filter, species == "Human")

# 2. View the original, detailed log
cat("--- Original Log ---\n")
read_log(original_chronicle)

# 3. Zap the log
zapped_chronicle <- zap_log(original_chronicle)

# 4. View the new, simplified log
cat("\n--- Zapped Log ---\n")
read_log(zapped_chronicle)

# 5. The underlying data value is unaffected
identical(
  unveil(original_chronicle, "value"),
  unveil(zapped_chronicle, "value")
)

}
