% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_columns.R
\name{report_columns}
\alias{report_columns}
\title{HTML interactive report detailing each column on a table}
\usage{
report_columns(
  dt,
  by_column = NULL,
  filename = NULL,
  output_format = "rmdformats",
  title = NULL,
  author = NULL,
  plot_palette = NULL,
  plot_palette_generator = "plasma",
  horizontal_bars = TRUE,
  sort_bars_value = TRUE,
  sort_bars_decreasingly = TRUE,
  rmdformats_theme = "downcute",
  prettydoc_theme = "leonids",
  number_sections = TRUE,
  table_of_content = TRUE,
  table_of_content_depth = 1,
  fig_width = 9,
  fig_height = 4,
  directory = getwd(),
  keep_rmd = FALSE,
  render_reports = TRUE
)
}
\arguments{
\item{dt}{Table to be studied.}

\item{by_column}{Name of the column to use as groups for all the other plots. Default is NULL.}

\item{filename}{Name of the output file. If not supplied, a generic name will be created.}

\item{output_format}{The format of the R Markdown output. Default is 'rmdformats'.}

\item{title}{Title of the report. If NULL (default), no title will be added.}

\item{author}{Author of the report. Default is NULL.}

\item{plot_palette}{Character vector of hex codes to use on plots.}

\item{plot_palette_generator}{Palette from the viridis package used in case plot_palette is unspecified (or insufficient for the number of colors required.) Default value is 'plasma', and possible values are 'viridis', 'inferno', 'magma', 'plasma', 'cividis'.}

\item{horizontal_bars}{Plot bars for categorical variables horizontally. Default is FALSE}

\item{sort_bars_value}{Sort the bars by value. Default is FALSE.}

\item{sort_bars_decreasingly}{Sort the bars decreasingly. Default is TRUE.}

\item{rmdformats_theme}{The theme to be used for [rmdformats](https://github.com/juba/rmdformats) outputs. Default is "downcute", and possible values are "downcute", "robobook", "material", "readthedown", "html_clean", "html_docco".}

\item{prettydoc_theme}{Name of the theme used on prettydoc. Default is leonids.}

\item{number_sections}{Whether or not to number the sections and subsections fo the report.}

\item{table_of_content}{Whether or not to include a table fo content at the beginning of the report.}

\item{table_of_content_depth}{The depth of sections and subsections to be displayed on the table of content.}

\item{fig_width}{Set the global figure width or the rmarkdown file.}

\item{fig_height}{Set the global figure height or the rmarkdown file.}

\item{directory}{The directory in which to render the .html report}

\item{keep_rmd}{Whether or not to keep the .Rmd file. Default is false.}

\item{render_reports}{Whether or not to render the reports. Default is TRUE. Set render_reports = FALSE and keep_rmd = TRUE to only build the R Markdown files}
}
\value{
Creates an HTML file with a plot for each column on the given table: a box plot for each numerical variable, and a bar plot for each categorical variable.
}
\description{
Creates an Rmarkdown report plotting each column of a dataset.
Categorical columns are plotted in bar plots, and numerical
columns are plotted in box plots. If 'by_column' is provided,
these plots will be grouped by the values of that column
}
\examples{
# chronicle::report_columns(dt = iris,
#                           by_column = 'Species',
#                           horizontal_bars = TRUE,
#                           keep_rmd = TRUE)
}
