% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_interface.R
\name{render_report}
\alias{render_report}
\title{Render the report using all objects from the global environment}
\usage{
render_report(
  report = "",
  output_format = "rmdformats",
  filename = paste("report", gsub(x = Sys.Date(), pattern = "-", replacement = ""), sep
    = "_"),
  title = NULL,
  author = NULL,
  include_date = TRUE,
  directory = getwd(),
  keep_rmd = FALSE,
  render_reports = TRUE,
  number_sections = FALSE,
  table_of_content = FALSE,
  table_of_content_depth = 1,
  fig_width = 9,
  fig_height = 5,
  plot_palette = NULL,
  plot_palette_generator = "plasma",
  rmdformats_theme = "downcute",
  prettydoc_theme = "leonids",
  docx_reference_file = NULL,
  pptx_reference_file = NULL,
  rticles_template = "arxiv_article",
  html_theme = "simplex",
  custom_output = NULL
)
}
\arguments{
\item{report}{Character string containing all the R Markdown chunks previously added (through chronicle::add_* functions.) Default is '', an empty report.}

\item{output_format}{The format of the R Markdown file. Default is prettydoc. Currently supported: 'bookdown', 'github_document', 'html_document', 'html_notebook', 'ioslides', 'pagedown', 'powerpoint_presentation', 'pdf', 'prettydoc', 'rmdformats', 'rolldown', 'rticles', 'slidy_presentation', 'tufte_handout', 'tufte_html', 'word_document'. Also 'felxdashboard' and 'xaringan' technically compile, but the layout is stiff in flexdashborad and altogether incorrect in xaringan.}

\item{filename}{The name of the .html file(s) created. If NULL (default), no author will be added.}

\item{title}{Title of the report. If NULL (default), no title will be added.}

\item{author}{Author of the report. If NULL (default), no author will be added.}

\item{include_date}{Whether or not to include the date as part of the header. Default is TRUE.}

\item{directory}{The directory in which to render the .html report}

\item{keep_rmd}{Whether or not to keep the .Rmd file. Default is false.}

\item{render_reports}{Whether or not to render the reports. Default is TRUE. Set render_reports = FALSE and keep_rmd = TRUE to only build the R Markdown files}

\item{number_sections}{Whether or not to number the sections and subsections fo the report.}

\item{table_of_content}{Whether or not to include a table fo content at the beginning of the report. Some formats does not allow overriding this.}

\item{table_of_content_depth}{The depth of sections and subsections to be displayed on the table of content.}

\item{fig_width}{Set the global figure width or the rmarkdown file.}

\item{fig_height}{Set the global figure height or the rmarkdown file.}

\item{plot_palette}{Character vector of hex codes to use on plots.}

\item{plot_palette_generator}{Palette from the [viridis](https://cran.r-project.org/web/packages/viridis/vignettes/intro-to-viridis.html#the-color-scales) package used in case plot_palette is unspecified (or insufficient for the number of colors required.) Default value is 'plasma', and possible values are 'viridis', 'inferno', 'magma', 'plasma', 'cividis', 'mako', 'rocket', and 'turbo'.}

\item{rmdformats_theme}{The theme to be used for [rmdformats](https://github.com/juba/rmdformats) outputs. Default is "downcute", and possible values are "downcute", "robobook", "material", "readthedown", "html_clean", "html_docco".}

\item{prettydoc_theme}{Name of the theme used on [prettydoc](https://prettydoc.statr.me/themes.html). Default is "leonids", and ossible values are "cayman", "tactile", "architect", "leonids", "hpstr".}

\item{docx_reference_file}{The path for a blank Microsoft Word document to use as template for the 'word_document' output.}

\item{pptx_reference_file}{The path for a blank Microsoft PowerPoint document to use as template for the 'powerpoint_presentation' output.}

\item{rticles_template}{The theme to be used fo [rticles](https://github.com/rstudio/rticles). Default is "arxiv_article"}

\item{html_theme}{The theme to be used for [hmtl_document](https://www.datadreaming.org/post/r-markdown-theme-gallery/) outputs. Default is "simplex".}

\item{custom_output}{[Experimental] A custom element for a yaml structure to specify as the output format of the R Markdown file. This is to get output formats not currently supported.#'}
}
\value{
Renders the report as an HTML file.
}
\description{
Render the report using all objects from the global environment
}
\examples{
# report_demo <- add_title(title = 'This is how a chronicle report looks', title_level = 1) \%>\%
# add_density(dt = iris, groups = 'Species', value = 'Sepal.Length', faceted = F) \%>\%
#   add_boxplot(dt = iris, groups = 'Species', value = 'Sepal.Length') \%>\%
#   add_barplot(dt = iris, bars = 'Species', value = 'Sepal.Length')
#   add_table(table = iris,
#             table_title = 'This is the iris dataset. Smells good!',
#             html_table_type = 'kable') \%>\%
#   add_table(table = mpg,
#             table_title = 'And this is mpg',
#             html_table_type = 'DT')
# render_report(report = report_demo,
#              title = 'Demo Output',
#              author = 'This is the author',
#              filename = 'demo_output',
#              output_format = 'prettydoc',
#              keep_rmd = TRUE)
}
