% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sortList.R
\name{sortList}
\alias{sortList}
\title{Sort the chromosome list  according to the chromosome number}
\usage{
sortList(id = id, tex = tex, chrsig = "single")
}
\arguments{
\item{id}{The identifier list of the Fasta file made by subFasID}

\item{tex}{A chromosome Fasta file in list format made by readToList function}

\item{chrsig}{The number of characters of the chromosome,
either "single" or "double", the previous means a single character
following "chr" in the Fasta identifier, the latter means two characters
following "chr" in the Fasta identifier. eg."chr1,chrX,chrY,chrM" is
"single";"chr10,chr11" is "double". If you want to obtain
both "single" and "double" sorted list of chromosome, try
"single" and "double" respectively}
}
\value{
The sorted chromosome Fasta file in list format.
}
\description{
Sort the chromosome list  according to the chromosome number
}
\examples{
data("tex")
data("text")
text<- replaceText(type = "text",input = text)
id <- subFasID(text = text)
tex2<- sortList(id=id,tex = tex,chrsig = "single")
tex3 <- sortList(id=id,tex = tex,chrsig = "double")
}
