% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readToList.R
\name{readToList}
\alias{readToList}
\title{Make a list file from large chromosome Fasta file}
\usage{
readToList(id = id, text = text, con = con)
}
\arguments{
\item{id}{The id list made from subFasID function}

\item{text}{Large character read in by readLines function from Fasta file}

\item{con}{A connection object or a character string, the connection must refer to the same Fasta file as text}
}
\value{
Chromosome Fasta file in list format.
}
\description{
Make a list file from large chromosome Fasta file
}
\examples{
data("text")
id <- subFasID(text = text)
fil <- tempfile(fileext = ".data")
write(text,file = fil)
con0 <- file(fil, "r")
tex <- readToList(id,text = text,con = con0)
}
