
test_that("tbats_predictor works correctly on TSLA.Close", {
  data(ts_set)
  preds <- chopper:::tbats_predictor(ts_set$TSLA.Close, h = 3)

  expect_type(preds, "list")
  expect_named(preds, c("t1", "t2", "t3"))
  expect_true(all(sapply(preds, function(x) is.function(x$rfun))))
  expect_true(all(sapply(preds, function(x) is.function(x$dfun))))
})

test_that("arfima_predictor returns numeric forecasts for AMZN.Close", {
  data(ts_set)
  preds <- chopper:::arfima_predictor(ts_set$AMZN.Close, h = 2)
  samples <- preds$t1$rfun(50)

  expect_length(samples, 50)
  expect_type(samples, "double")
  expect_true(all(is.finite(samples)))
})

test_that("theta_predictor returns a valid forecast for IBM.Close", {
  data(ts_set)
  preds <- chopper:::theta_predictor(ts_set$IBM.Close, h = 4)

  expect_length(preds, 4)
  expect_named(preds, paste0("t", 1:4))
  expect_true(all(sapply(preds, function(x) is.function(x$rfun))))
  expect_true(all(sapply(preds, function(x) is.function(x$dfun))))
})

test_that("product_of_experts combines models correctly for META.Close", {
  data(ts_set)
  preds <- chopper:::product_of_experts(ts_set$META.Close, horizon = 3, n_samples = 100)

  expect_type(preds, "list")
  expect_true(all(sapply(preds, function(x) is.function(x$rfun))))
  expect_true(all(sapply(preds, function(x) is.function(x$dfun))))
})

test_that("chopper handles longer horizon on TSLA.Close", {
  data(ts_set)
  result <- chopper(ts_set$TSLA.Close, horizon = 10, n_samples = 100)

  expect_type(result, "list")
  expect_length(result, 3)
  expect_named(result, c("pred_funs", "plot", "time_log"))
})

test_that("chopper works on ts_set using TSLA.Close", {
  data(ts_set)
  ts_data <- ts_set$TSLA.Close
  result <- chopper(ts_data, horizon = 5, n_samples = 100)

  expect_type(result, "list")
  expect_named(result, c('pred_funs', 'plot', 'time_log'))
  expect_true(all(sapply(1:5,function(x) is.function(result$pred_funs[[x]]$rfun))))
})

