% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sohoGraph.R
\name{sohoGraph}
\alias{sohoGraph}
\title{Compute network graph of roads and embed cases, landmarks and pumps (prototype).}
\usage{
sohoGraph(vestry = FALSE, case.set = "observed", embed.addr = TRUE,
  embed.landmarks = TRUE, embed.pumps = TRUE, latlong = FALSE,
  drop.isolates = FALSE)
}
\arguments{
\item{vestry}{Logical. Use Vestry Report pump data.}

\item{case.set}{Character. "observed", "expected", or "snow". "snow" captures John Snow's annotation of the Broad Street pump neighborhood printed in the Vestry report version of the map.}

\item{embed.addr}{Logical. Embed all 321 or selected anchor case addresses into graph network.}

\item{embed.landmarks}{Logical or Numeric. Embed all or selected landmarks into road network.}

\item{embed.pumps}{Logical or Numeric. Embed all or selected pumps into road network.}

\item{latlong}{Logical. Use estimated longitude and latitude.}

\item{drop.isolates}{Logical. Exclude Adam and Eve Court (and Pump #2) and Falconberg Court and Mews.}
}
\value{
An R list of nodes, edges and an 'igraph' network graph.
}
\description{
Compute network graph of roads and embed cases, landmarks and pumps (prototype).
}
