% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/euclideanNominal.R
\name{plot.euclidean}
\alias{plot.euclidean}
\title{Plot method for neighborhoodEuclidean().}
\usage{
\method{plot}{euclidean}(x, type = "star", add = FALSE,
  add.observed.points = TRUE, alpha.level = 0.75, polygon.type = "solid",
  ...)
}
\arguments{
\item{x}{An object of class "euclidean" created by \code{neighborhoodEuclidean()}.}

\item{type}{Character. "star", "area.points" or "area.polygons". "area" flavors only valid when \code{case.set = "expected"}.}

\item{add}{Logical. Add graphic to an existing plot.}

\item{add.observed.points}{Logical. Add observed fatality "addresses".}

\item{alpha.level}{Numeric. Alpha level transparency for area plot: a value in [0, 1].}

\item{polygon.type}{Character. "perimeter" or "solid".}

\item{...}{Additional plotting parameters.}
}
\value{
A base R plot.
}
\description{
Plot method for neighborhoodEuclidean().
}
\note{
This uses an approximate computation of polygons, using the 'TSP' package, that may produce non-simple and/or overlapping polygons.
}
\examples{
\dontrun{
plot(neighborhoodEuclidean())
plot(neighborhoodEuclidean(-6))
plot(neighborhoodEuclidean(pump.select = 6:7))
plot(neighborhoodEuclidean(case.set = "expected"), type = "area.points")
plot(neighborhoodEuclidean(case.set = "expected"), type = "area.polygons")
}
}
