% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_by_file_extension.R
\name{select_by_file_extension}
\alias{select_by_file_extension}
\title{Select string that end in a particular way (e.g. a certain file extension)}
\usage{
select_by_file_extension(strings, file_extension)
}
\arguments{
\item{strings}{vector of character strings for elements to be extracted from.}

\item{file_extension}{character string specifying the extension of the file type to be selected.
This can also be any other trailing string that marks all vector elements to be selected.}
}
\value{
subset of the strings vector that only contains the elements that end on file_extension.
}
\description{
Sometimes it makes sense to apply a function to several files in a folder, but only to
those of a particular file type. This function can selects all elements in a vector of strings
that end in a particular way, e.g. on a common file extension.
}
\examples{

  select_by_file_extension(c("Temp1.csv","Temp1.xls","Temp2.csv","Temp2.xls"),"csv")
  select_by_file_extension(c("red car","blue car","yellow duck"), "car")
 
}
\author{
Eike Luedeling
}
\keyword{utility}
