% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_tab.R
\name{read_tab}
\alias{read_tab}
\title{Read csv table regardless of whether it is a true csv or the French type}
\usage{
read_tab(tab)
}
\arguments{
\item{tab}{file name of a table to be read.}
}
\value{
If the table is in one of the two formats described above, the stored table
is returned.
}
\description{
csv tables are widely used for storing data as 'comma-separated values'.
This doesn't work, however, when the comma is also used as a decimal symbol,
as is practiced in French or German, for example. The separator symbol for csv
files then becomes a semi-colon. This is not problematic when you only work on one
machine, but it causes problems when you collaborate with people who use different
types of csv encoding.
}
\details{
This function overcomes this problem by checking first, which of the two
characters occurs most frequently in the table, assuming then that this is
the separator symbol. It then opens the table accordingly.

Currently limited to files that are either comma-separated with point as decimal
symbol or semicolon-separated with comma as decimal symbol. Files should also
have a header.
}
\examples{

df<-data.frame(Var1=c(1,2,3.2,1.2),Var2=c(1.2,6,2.6,7))
write.csv(df,"filecsv.csv",row.names=FALSE)
read_tab("filecsv.csv")
write.table(df,"filesemicolon.csv",sep=";",dec=",")
read_tab("filesemicolon.csv")
file.remove("filecsv.csv")
file.remove("filesemicolon.csv")

 
}
\author{
Eike Luedeling
}
\keyword{utility}
