% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMSEP_RPD.R
\name{RPIQ}
\alias{RPIQ}
\title{Ratio of Performance to InterQuartile distance (RPIQ)}
\usage{
RPIQ(predicted, observed, na.rm = FALSE)
}
\arguments{
\item{predicted}{a numeric vector containing predicted values.}

\item{observed}{a numeric vector of the same length as ```predicted```
containing observed values.}

\item{na.rm}{Boolean parameter indicating whether NA values should be removed before the analysis}
}
\value{
numeric value of the RPIQ
}
\description{
This function computes the Ratio of Performance to InterQuartile
distance (RPIQ), which
is defined as interquartile range of the observed values divided by
the Root Mean Square Error or Prediction (RMSEP). The RPIQ takes both
the prediction error and the variation of observed values into 
account, providing a metric of model validity that is more objective
than the RMSEP and more easily comparable across model validation
studies. The greater the RPIQ, the better the model's predictive
capacity. In contrast to the Residual Prediction Deviation (RPD),
the RPIQ makes no assumptions about the distribution of the
observed values (since the RDP includes a standard deviation, it
assumed normal distribution of the observed values).
}
\details{
Interpretation of the RPIQ differs in the literature, with different
thresholds used for judging model quality.
}
\examples{

predicted<-c(1,2,3,4,5,6,7,8,9,10)
observed<-c(1.5,1.8,3.3,3.9,4.4,6,7.5,9,11,10)

RPD(predicted,observed)

}
\references{
Bellon-Maurel V, Fernandez-Ahumada E, Palagos B,
Roger J-M, McBratney A, 2010. Critical review of chemometric
indicators commonly used for assessing the quality of the prediction
of soil attributes by NIR spectroscopy, In TrAC Trends in Analytical
Chemistry 29(9), 1073-1081.
}
\author{
Eike Luedeling
}
\keyword{model}
\keyword{validation}
