% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcdg_nld_smocc.R
\docType{data}
\name{gcdg_nld_smocc}
\alias{gcdg_nld_smocc}
\title{The Netherlands 0-2.5 years: \code{gcdg_nld_smocc}}
\format{
A \code{data.frame} with 16722 rows and 64 variables:\tabular{lll}{
   Name \tab Type \tab Label \cr
   \code{ctrcd} \tab chr \tab Country code (ISO 3166-1 alpha-3) \cr
   \code{cohort} \tab chr \tab Cohort name \cr
   \code{cohortn} \tab chr \tab Cohort number \cr
   \code{subjid} \tab int \tab Child number \cr
   \code{agedays} \tab int \tab Age (days) \cr
   \code{sex} \tab chr \tab Either \code{"male"} or  \code{"female"} \cr
   \code{gagebrth} \tab int \tab Gestational age (days) \cr
   \code{ddicmm029} \tab 0/1 \tab Reacts when spoken to \cr
   \code{ddicmm030} \tab 0/1 \tab Smiles in response (M; can ask parents) \cr
   \code{ddicmm031} \tab 0/1 \tab vocalizes in response \cr
   \code{ddicmm033} \tab 0/1 \tab Says dada, baba, gaga \cr
   \code{ddicmm034} \tab 0/1 \tab Babbles while playing \cr
   \code{ddicmm036} \tab 0/1 \tab Waves 'bye-bye' (M; can ask parents) \cr
   \code{ddicmm037} \tab 0/1 \tab Uses two words with comprehension \cr
   \code{ddicmm039} \tab 0/1 \tab Says three 'words' \cr
   \code{ddicmm041} \tab 0/1 \tab Says sentences with 2 words \cr
   \code{ddicmm043} \tab 0/1 \tab Refers to self using 'me' or 'I' (M; can ask parents) \cr
   \code{ddicmd044} \tab 0/1 \tab Points at 5 pictures in the book \cr
   \code{ddicmd116} \tab 0/1 \tab Turn head to sound \cr
   \code{ddicmd136} \tab 0/1 \tab Reacts to verbal request (M; can ask parents) \cr
   \code{ddicmd141} \tab 0/1 \tab Identifies two named objects \cr
   \code{ddicmd148} \tab 0/1 \tab Understands 'play' orders \cr
   \code{ddifmd001} \tab 0/1 \tab Eyes fixate \cr
   \code{ddifmd002} \tab 0/1 \tab Follows with eyes and head 30d  < 0 > 30d \cr
   \code{ddifmd003} \tab 0/1 \tab Hands open occasionally \cr
   \code{ddifmm004} \tab 0/1 \tab Watches own hands \cr
   \code{ddifmd005} \tab 0/1 \tab Plays with hands in midline \cr
   \code{ddifmd007} \tab 0/1 \tab Passes cube from hand to hand \cr
   \code{ddifmd008} \tab 0/1 \tab Holds cube, grasps another one with other hand \cr
   \code{ddifmm009} \tab 0/1 \tab Plays with both feet \cr
   \code{ddifmd010} \tab 0/1 \tab Picks up pellet between thumb and index finger \cr
   \code{ddifmd011} \tab 0/1 \tab Puts cube in and out of a box \cr
   \code{ddifmm012} \tab 0/1 \tab Plays 'give and take' (M; can ask parents) \cr
   \code{ddifmd013} \tab 0/1 \tab Tower of 2 cubes \cr
   \code{ddifmm014} \tab 0/1 \tab Explores environment energetically (M; can ask parents) \cr
   \code{ddifmd015} \tab 0/1 \tab Builds tower of 3 cubes \cr
   \code{ddifmm016} \tab 0/1 \tab Imitates everyday activities (M; can ask parents) \cr
   \code{ddifmd017} \tab 0/1 \tab Tower of 6 cubes \cr
   \code{ddifmd018} \tab 0/1 \tab Places round block in board \cr
   \code{ddifmm019} \tab 0/1 \tab Takes off shoes and socks (M; can ask parents) \cr
   \code{ddifmd154} \tab 0/1 \tab Eats with spoon without help (M; can ask parents) \cr
   \code{ddigmd006} \tab 0/1 \tab Grasps object within reach \cr
   \code{ddigmd052} \tab 0/1 \tab Moves arms equally well \cr
   \code{ddigmd053} \tab 0/1 \tab Moves legs equally well \cr
   \code{ddigmd054} \tab 0/1 \tab Stays suspended when lifted under the armpits \cr
   \code{ddigmd055} \tab 0/1 \tab No head lag if pulled to sitting \cr
   \code{ddigmd056} \tab 0/1 \tab Lifts chin off table for a moment \cr
   \code{ddigmd057} \tab 0/1 \tab Lifts head to 45 degrees on prone position \cr
   \code{ddigmd058} \tab 0/1 \tab Looks around to side with angle face-table 90 \cr
   \code{ddigmd059} \tab 0/1 \tab Flexes or stomps legs while being swung \cr
   \code{ddigmm060} \tab 0/1 \tab Rolls over back to front \cr
   \code{ddigmd061} \tab 0/1 \tab Balances head well while sitting \cr
   \code{ddigmd062} \tab 0/1 \tab Sits on buttocks while legs stretched \cr
   \code{ddigmd063} \tab 0/1 \tab Sits in stable position without support \cr
   \code{ddigmm064} \tab 0/1 \tab Crawls forward, abdomen on the floor \cr
   \code{ddigmm065} \tab 0/1 \tab Pulls up to standing position \cr
   \code{ddigmm066} \tab 0/1 \tab Crawls, abdomen off the floor (M; can ask parents) \cr
   \code{ddigmm067} \tab 0/1 \tab Walks while holding onto play-pen or furniture \cr
   \code{ddigmd068} \tab 0/1 \tab Walks alone \cr
   \code{ddigmd069} \tab 0/1 \tab Throws ball without falling \cr
   \code{ddigmd070} \tab 0/1 \tab Squats or bends to pick things up \cr
   \code{ddigmd071} \tab 0/1 \tab Kicks ball \cr
   \code{ddigmd146} \tab 0/1 \tab Drinks from cup (M; can ask parents) \cr
   \code{ddigmd168} \tab 0/1 \tab Walks well \cr
}
}
\usage{
gcdg_nld_smocc
}
\description{
A dataset with developmental scores at the item level for
2038 children measured at 16722 visits (rows) between ages 0-2.5 year.
}
\details{
The combination of \code{subjid} and \code{agedays} identifies each unique visit (row).

Instruments: Dutch Development Instrument (Van Wiechenschema, version 1983): \code{ddi}
}
\examples{
head(gcdg_nld_smocc)
}
\references{
Herngreen WP, Reerink JD, van Noord-Zaadstra BM, Verloove-Vanhorick SP,
Ruys JH. The SMOCC-study: Design of a representative cohort of live-born
infants in the Netherlands. European Journal of Public Health. 1992;2:117-122.
}
\keyword{datasets}
