% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FOMT.R
\name{FOMT}
\alias{FOMT}
\title{First-Order Multi-Target model regression}
\usage{
FOMT(dtframe)
}
\arguments{
\item{dtframe}{A data-frame containing 2 or 3 columns: time, normalized
concentration and error (optional), respectively}
}
\value{
Returns the results of the regression as a
\link[stats:nls]{nls} object.
}
\description{
The function performs a non-linear regression using the first-order
multi-target model. The model equation is:
\deqn{\frac{S}{S_0}=1-(1-e^{-k\,t})^m}
where \eqn{S/S_0} is the fraction of surviving molecules, \eqn{k} is the
average number of hits per time unit, \eqn{m} is the number of hits required
to degrade the molecule, and  \eqn{t} is time.
}
\details{
The FOMT model has been proposed as an alternative to the Weibull equation
that is commonly used when the time-dependent behavior of the data
significantly deviates from that predicted by standard chemical models.
}
\examples{
t <- c(0, 4, 8, 12, 16, 20)
conc <- c(1, 0.98, 0.99, 0.67, 0.12, 0.03)
err <- c(0.02, 0.05, 0.04, 0.04, 0.03, 0.02)
dframe <- data.frame(t, conc, err)
FOMT <- FOMT(dframe)
plot(dframe[[1]], dframe[[2]])
arrows(dframe[[1]], dframe[[2]] + dframe[[3]],
  dframe[[1]], dframe[[2]] - dframe[[3]],
  length = 0
)
newt <- seq(0, 21, by = 0.1)
lines(newt, predict(FOMT, newdata = list(t = newt)))

dframe1 <- data.frame(t, conc)
FOMT1 <- FOMT(dframe1)
plot(dframe1[[1]], dframe1[[2]])
lines(newt, predict(FOMT1, newdata = list(t = newt)))
summary(FOMT)
summary(FOMT1)
}
\seealso{
\code{\link[=FOMTm]{FOMTm()}}, \code{\link[=par_est_FOMT]{par_est_FOMT()}}
}
