% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isNaVectorOrNull.R
\name{isNaVectorOrNull}
\alias{isNaVectorOrNull}
\title{Wrapper for the checkarg function, using specific parameter settings.}
\usage{
isNaVectorOrNull(argument, default = NULL, stopIfNot = FALSE, n = NA,
  message = NULL, argumentName = NULL)
}
\arguments{
\item{argument}{See checkarg function.}

\item{default}{See checkarg function.}

\item{stopIfNot}{See checkarg function.}

\item{n}{See checkarg function.}

\item{message}{See checkarg function.}

\item{argumentName}{See checkarg function.}
}
\value{
See checkarg function.
}
\description{
This function can be used in 3 ways:\enumerate{
  \item Return TRUE or FALSE depending on whether the argument checks are
     passed. This is suitable e.g. for if statements that take further action
     if the argument does not pass the checks.\cr
  \item Throw an exception if the argument does not pass the checks. This is
     suitable e.g. when no further action needs to be taken other than
     throwing an exception if the argument does not pass the checks.\cr
  \item Same as (2) but by supplying a default value, a default can be assigned
     in a single statement, when the argument is NULL. The checks are still
     performed on the returned value, and an exception is thrown when not
     passed.\cr
}
}
\details{
Actual call to checkarg: checkarg(argument, "N", default = default, stopIfNot = stopIfNot, nullAllowed = TRUE, n = NA, zeroAllowed = FALSE, negativeAllowed = FALSE, positiveAllowed = FALSE, nonIntegerAllowed = TRUE, naAllowed = TRUE, nanAllowed = FALSE, infAllowed = FALSE, message = message, argumentName = argumentName)
}
\examples{
isNaVectorOrNull(NA)
   # returns TRUE (argument is valid)
isNaVectorOrNull("X")
   # returns FALSE (argument is invalid)
#isNaVectorOrNull("X", stopIfNot = TRUE)
   # throws exception with message defined by message and argumentName parameters

}
