% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertBullet2Sentence.R
\name{convertBullet2Sentence}
\alias{convertBullet2Sentence}
\title{convertBullet2Sentence}
\usage{
convertBullet2Sentence(
  Model = "gpt-4o-mini",
  temperature = 1,
  verbose = TRUE,
  SpeakJA = FALSE,
  SelectedCode = TRUE
)
}
\arguments{
\item{Model}{The OpenAI GPT model to use for text generation. Default is "gpt-4o-mini".}

\item{temperature}{The temperature parameter for text generation. Default is 1.}

\item{verbose}{Logical flag to indicate whether to display progress. Default is TRUE.}

\item{SpeakJA}{Logical flag to indicate whether to use Japanese speech output. Default is FALSE.}

\item{SelectedCode}{Logical flag to indicate whether to use selected text in RStudio. Default is TRUE.}
}
\value{
Inserts the converted sentences into the RStudio editor if `SelectedCode` is TRUE, otherwise writes to clipboard.
}
\description{
Convert bullet points to sentences using OpenAI GPT model.
}
\details{
Convert Bullet Points to Sentences

This function takes bullet points as input and converts them into sentences.
The function uses the OpenAI GPT model for text generation to assist in the conversion.
The function can either take the selected text from the RStudio environment or from the clipboard.
}
\examples{
\dontrun{
# Option 1
# Select some text in RStudio and then run the rstudio addins
# Option 2
# Copy the text into your clipboard then execute
convertBullet2Sentence(Model = "gpt-4o-mini", SelectedCode = FALSE)
}
}
\author{
Satoshi Kume
}
