% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_nonparametric.R
\name{WBS.uni.nonpar}
\alias{WBS.uni.nonpar}
\title{Wild binary segmentation for univariate nonparametric change points detection.}
\usage{
WBS.uni.nonpar(Y, s, e, Alpha, Beta, N, delta, level = 0)
}
\arguments{
\item{Y}{A \code{numeric} matrix of observations with horizontal axis being time, and vertical axis being multiple observations on each time point.}

\item{s}{A \code{integer} scalar of starting index.}

\item{e}{A \code{integer} scalar of ending index.}

\item{Alpha}{A \code{integer} vector of starting indices of random intervals.}

\item{Beta}{A \code{integer} vector of ending indices of random intervals.}

\item{N}{A \code{integer} vector representing number of multiple observations on each time point.}

\item{delta}{A positive \code{integer} scalar of minimum spacing.}

\item{level}{Should be fixed as 0.}
}
\value{
A \code{list} with the following structure:
 \item{S}{A vector of estimated change points (sorted in strictly increasing order)}
 \item{Dval}{A vector of values of CUSUM statistic based on KS distance}
 \item{Level}{A vector representing the levels at which each change point is detected}
 \item{Parent}{A matrix with the starting indices on the first row and the ending indices on the second row}
}
\description{
Perform wild binary segmentation for univariate nonparametric change points detection.
}
\examples{
Y = t(as.matrix(c(rnorm(100, 0, 1), rnorm(100, 0, 10), rnorm(100, 0, 40))))
N = rep(1, 300)
M = 20
intervals = WBS.intervals(M = M, lower = 1, upper = ncol(Y))
temp = WBS.uni.nonpar(Y, 1, 300, intervals$Alpha, intervals$Beta, N, 5)
plot.ts(t(Y))
points(x = tail(temp$S[order(temp$Dval)], 4), y = Y[,tail(temp$S[order(temp$Dval)],4)], col = "red")
thresholdBS(temp, 2)
}
\references{
Padilla, Yu, Wang and Rinaldo (2021) <doi:10.1214/21-EJS1809>.
}
\seealso{
\code{\link{thresholdBS}} for obtaining change points estimation, \code{\link{tuneBSuninonpar}} for a tuning version.
}
\author{
Oscar Hernan Madrid Padilla, Haotian Xu
}
