% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEPP.R
\name{DP.SEPP}
\alias{DP.SEPP}
\title{Dynamic programming for SEPP change points detection through \eqn{l_0} penalty.}
\usage{
DP.SEPP(DATA, gamma, lambda, delta, delta2, intercept, threshold)
}
\arguments{
\item{DATA}{A \code{numeric} matrix of observations with horizontal axis being time.}

\item{gamma}{A \code{numeric} scalar of tuning parameter associated with the \eqn{l_0} penalty.}

\item{lambda}{A \code{numeric} scalar of tuning parameter for lasso penalty.}

\item{delta}{An \code{integer} scalar of minimum spacing for dynamic programming.}

\item{delta2}{An \code{integer} scalar representing the maximal of the change point spacing (for reducing computation cost).}

\item{intercept}{A \code{numeric} scalar representing the intercept of the model, which is assumed to be known.}

\item{threshold}{A \code{numeric} scalar representing the upper bound for each coordinate of X_t (for stability).}
}
\value{
An object of \code{\link[base]{class}} "DP", which is a \code{list} with the following structure:
 \item{partition}{A vector of the best partition.}
 \item{cpt}{A vector of change points estimation.}
}
\description{
Perform dynamic programming for SEPP change points detection.
}
\examples{
p = 8 # dimension
n = 15
s = 3 # s is sparsity
factor = 0.2 # large factor gives exact recovery
threshold = 4 # thresholding makes the process stable
intercept = 1/2 # intercept of the model. Assume to be known as in the existing literature
A1 = A2 = A3 = matrix(0, p, p)
diag(A1[,-1]) = 1
diag(A1) = 1
diag(A1[-1,]) = -1
A1 = A1*factor
A1[(s+1):p, (s+1):p] = 0
diag(A2[,-1]) = 1
diag(A2) = -1
diag(A2[-1,]) = 1
A2 = A2*factor
A2[(s+1):p, (s+1):p] = 0
data1 = simu.SEPP(intercept, n, A1, threshold, vzero = NULL)
data2 = simu.SEPP(intercept, n, A2, threshold, vzero = data1[,n])
data = cbind(data1, data2)
gamma = 0.1
delta = 0.5*n
delta2 = 1.5*n
intercept = 1/2
threshold = 6
DP_result = DP.SEPP(data, gamma = gamma, lambda = 0.03, delta, delta2, intercept, threshold)
cpt_hat = DP_result$cpt
}
\references{
Wang, D., Yu, Y., & Willett, R. (2020). Detecting Abrupt Changes in High-Dimensional Self-Exciting Poisson Processes. arXiv preprint arXiv:2006.03572.
}
\author{
Daren Wang & Haotian Xu
}
