% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_teams.R
\name{cfbd_team_matchup}
\alias{cfbd_team_matchup}
\title{\strong{Get matchup history between two teams.}}
\usage{
cfbd_team_matchup(team1, team2, min_year = NULL, max_year = NULL)
}
\arguments{
\item{team1}{(\emph{String} required): D-I Team 1}

\item{team2}{(\emph{String} required): D-I Team 2}

\item{min_year}{(\emph{Integer} optional): Minimum of year range, 4 digit format (\emph{YYYY})}

\item{max_year}{(\emph{Integer} optional): Maximum of year range, 4 digit format (\emph{YYYY})}
}
\value{
\link{cfbd_team_matchup} - A data frame with 11 variables:
\describe{
\item{\code{season}: integer.}{Season the game took place.}
\item{\code{week}: integer.}{Game week of the season.}
\item{\code{season_type}: character.}{Season type of the game.}
\item{\code{date}: character.}{Game date.}
\item{\code{neutral_site}: logical.}{TRUE/FALSE flag for if the game took place at a neutral site.}
\item{\code{venue}: character.}{Stadium name.}
\item{\code{home_team}: character.}{Home team of the game.}
\item{\code{home_score}: integer.}{Home score in the game.}
\item{\code{away_team}: character.}{Away team of the game.}
\item{\code{away_score}: integer.}{Away score in the game.}
\item{\code{winner}: character.}{Winner of the matchup.}
}
}
\description{
\strong{Get matchup history between two teams.}
}
\examples{
\donttest{
  try(cfbd_team_matchup("Texas", "Oklahoma"))

  try(cfbd_team_matchup("Texas A&M", "TCU"))

  try(cfbd_team_matchup("Texas A&M", "TCU", min_year = 1975))

  try(cfbd_team_matchup("Florida State", "Florida", min_year = 1975))
}

}
\seealso{
Other CFBD Teams: 
\code{\link{cfbd_team_info}()},
\code{\link{cfbd_team_matchup_records}()},
\code{\link{cfbd_team_roster}()},
\code{\link{cfbd_team_talent}()}
}
\concept{CFBD Teams}
\keyword{Matchup}
\keyword{Team}
