% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_ratings.R
\name{cfbd_rankings}
\alias{cfbd_rankings}
\title{\strong{Get historical Coaches and AP poll data}}
\usage{
cfbd_rankings(year, week = NULL, season_type = "both")
}
\arguments{
\item{year}{(\emph{Integer} required): Year, 4 digit format (\emph{YYYY})}

\item{week}{(\emph{Integer} optional): Week, values from 1-15, 1-14 for seasons pre-playoff (i.e. 2013 or earlier)}

\item{season_type}{(\emph{String} default both): Season type - regular, postseason, both, allstar, spring_regular, spring_postseason}
}
\value{
\code{\link[=cfbd_rankings]{cfbd_rankings()}} - A data frame with 9 variables:\tabular{ll}{
   col_name \tab types \cr
   season \tab integer \cr
   season_type \tab character \cr
   week \tab integer \cr
   poll \tab character \cr
   rank \tab integer \cr
   school \tab character \cr
   conference \tab character \cr
   first_place_votes \tab integer \cr
   points \tab integer \cr
}
}
\description{
\strong{Get historical Coaches and AP poll data}
}
\examples{
\donttest{
  try(cfbd_rankings(year = 2019, week = 12))

  try(cfbd_rankings(year = 2018, week = 14))

  try(cfbd_rankings(year = 2013, season_type = "postseason"))
}

}
\seealso{
Other CFBD Ratings and Rankings: 
\code{\link{cfbd_ratings_elo}()},
\code{\link{cfbd_ratings_fpi}()},
\code{\link{cfbd_ratings_sp}()},
\code{\link{cfbd_ratings_sp_conference}()},
\code{\link{cfbd_ratings_srs}()}
}
\concept{CFBD Ratings and Rankings}
\keyword{CFB}
\keyword{Rankings}
