% Generated by roxygen2 (4.0.2): do not edit by hand
\name{mnc}
\alias{mnc}
\title{Find the maximum neighborhood component (MNC)}
\usage{
mnc(graph, vids = V(graph), mode = c("all", "out", "in"))
}
\arguments{
\item{graph}{The input graph as igraph object}

\item{vids}{Vertex sequence, the vertices for which the centrality values are returned. Default is all vertices.}

\item{mode}{Character constatnt, it specifies how to use the direction of the edges if a directed graph is analyzed. For 'out' only the outgoing edges are followed. For 'in' all vertices from which the source vertex is reachable in at most order steps are counted. 'all' ignores the direction of the edges. This argument is ignored for undirected graphs.}
}
\value{
A numeric vector contaning the centrality scores for the selected vertices.
}
\description{
Maximum Neighborhood Component defined as:
\deqn{MNC(v)=\left|V(MC(v))\right|}{MNC(v)=|V(MC(v))|}
where where MC(v) is a maximum connected component of the \eqn{G[N(v)]}{G[N(v)]} and \eqn{G[N(v)]}{G[N(v)]} is the induced subgraph of G by \eqn{N(v)}{N(v)} and \eqn{N(v)}{N(v)} is neighborhoods of node \eqn{v}{v}.
}
\details{
The neighborhood of a node \eqn{v}{v}, nodes adjacent to \eqn{v}{v}, induce a subnetwork \eqn{N(v)}{N(v)}. The score of node \eqn{v}{v}, \eqn{MNC(v)}{MNC(v)}, is defined to be the size of the maximum connected component of \eqn{N(v)}{N(v)}. The neighborhood \eqn{N(v)}{N(v)} is the set of nodes adjacent to \eqn{v}{v} and does not contain node \eqn{v}{v}. \cr
More detail at \href{http://www.centiserver.org/?q1=centrality&q2=MNC_Maximum_Neighborhood_Component}{MNC-Maximum Neighborhood Component}
}
\examples{
g <- random.graph.game(20, 3/10)
mnc(g)
}
\author{
Mahdi Jalili \email{m_jalili@farabi.tums.ac.ir}
}
\references{
Lin, Chung-Yen, et al. "Hubba: hub objects analyzer-a framework of interactome hubs identification for network biology." Nucleic acids research 36.suppl 2 (2008): W438-W443.
}

