% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdfinv.R
\name{cdfinv}
\alias{cdfinv}
\title{Computation of confidence intervals via CDF inversion}
\usage{
cdfinv(
  DISTR,
  PARAM,
  STAT,
  lpb = -10000,
  upb = 10000,
  bound = "two-sided",
  alpha = 0.05,
  tolb = 1e-06,
  tol = 1e-06,
  ...
)
}
\arguments{
\item{DISTR}{name of sampling distribution in R}

\item{PARAM}{name of distribution parameter for which we are computing an interval estimate}

\item{STAT}{observed value of the chosen statistic}

\item{lpb}{lower bound of search interval}

\item{upb}{upper bound of search interval}

\item{bound}{one of "two-sided", "lower", or "upper"}

\item{alpha}{the confidence coefficient is 1 - alpha}

\item{tolb}{search interval bound offset value}

\item{tol}{convergence tolerance for uniroot function}

\item{...}{additional arguments for DISTR's cdf function}
}
\value{
A list with interval bounds and associated cdf values.
\itemize{
  \item DISTR - The distribution name (as given in R)
  \item PARAM - The parameter name (as given in R)
  \item STAT - The observed statistic value
  \item bound - The interval bound(s)
  \item q - The cdf quantile(s) associated with the interval bound(s)
}
}
\description{
cdfinv() returns one- or two-sided confidence interval estimates.
}
\examples{
cdfinv("norm","mean",3.45,sd=2) ## returns -0.4699279 and 7.3699277
cdfinv("gamma","rate",12.25,lpb=0,bound="upper",shape=10) ## returns 1.282058
cdfinv("nbinom","prob",22,lpb=0,upb=1,bound="lower",size=10) ## returns 0.1803843
}
\author{
Peter E. Freeman, \email{pfreeman@cmu.edu}
}
