#' Cumulative distribution function for t distribution
#'
#' Computes the quantile of the chi-square distribution for n-1 degrees of freedom corresponding to the input value of the sample variance.
#'
#' Do not call pnormvar() directly.
#' Pass DISTR="normvar" to cdfinv() when computing intervals for the
#' normal variance.
#' The parameter name to be passed to cdfinv() is sigma2.
#' The additional argument n (sample size) is to be passed to cdfinv().
#'
#' @param q coordinate at which the cdf is to be evaluated (named in accordance with R standards)
#' @param sigma2 the assumed normal variance
#' @param n the sample size (pass this as an extra argument to cdfinv())
#'
#' @returns The quantile of the chi-square distribution for n-1 degrees of freedom corresponding to the input value of the sample variance.
#'
#' @author Peter E. Freeman, \email{pfreeman@@cmu.edu}
#'
#' @examples
#' cdfinv("normvar","sigma2",14.35,lpb=0,n=22) ## returns 8.493787 29.305942
pnormvar <- function(q,sigma2,n)
{
  if ( n == 1 ) stop("At least two observations are required for normal variance confidence intervals.")
  pchisq(q*(n-1)/sigma2,n-1)
}
