% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nvdescstat.R
\name{nvdescstat}
\alias{nvdescstat}
\title{Numerical Variable Descriptive Statistics returns a data frame containing descriptive statistics for numerical variable.}
\usage{
nvdescstat(df)
}
\arguments{
\item{df}{- Input Data frame.}
}
\value{
Returns a data frame containing descriptive statistics for numerical variable.
}
\description{
Returns a data frame containing following descriptive statistics for numerical variables in a data frame.
             % Missing Value       -Percent of missing values in the variable. 
             Min Value             -Minimum value of the variable.
             Max Value             -Maximum value of the variable.
             Mean                  -Mean of the variable.
             Median                -Median of the variable.
             Variance              -Variance of the variable.
             Standard Deviation    -Standard Deviation of the variable.
             Lower Outlier Cutoff  -This helps to detect Lower outliers.
             Upper Outlier Cutoff  -This helps to detect Upper outliers.
}
\examples{
numv1<-c(8000,200,323)
numv2<-c(400,533,633)
numv3<-c(100,534,734)
numv4<-c(1,25,34)
chrv6<-c("a","b","c")
numv5<-c(50,10000,34000)
chrv7<-as.factor(c("male","female","unknown"))
numv6<-c(NA,300,340)
df<-data.frame(numv1,numv2,chrv6,numv3,numv4,numv5,chrv7,numv6)
nvdescstatdf<-nvdescstat(df)
}
\author{
"Sandip Kumar Gupta", "sandip_nitj@yahoo.co.in"
}
