#' Simulated data from Hirano and Imbens (2004)
#'
#' Simulated data used in the paper "The propensity score with continuous
#' treatments."
#'
#' A dataset containing hi_sim_data.
#'
#' @format A data frame with 1000 rows and 6 variables:
#'
#'
#' @source use the \code{hi_sample} function
#'
#' @references
#' Hirano, Keisuke, and Guido W. Imbens.
#' "The propensity score with continuous treatments."
#' \emph{Applied Bayesian modeling and causal inference from
#' incomplete-data perspectives} (2004): 73-84.
#'
#'
#' Moodie, Erica EM, and David A. Stephens.
#'  "Estimation of dose-response functions for longitudinal data
#'   using the generalised propensity score."
#'   \emph{Statistical methods in medical research} \bold{21.2} (2012): 149-166.
#'
#'
#' @examples
#'
#' ## Example from Hirano and Imbens (2004).
#' data(hi_sim_data)
#' head(hi_sim_data)
#'
#'
#' @usage
#' data(hi_sim_data)
#'
#'
#'
"hi_sim_data"
