% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{social_insure}
\alias{social_insure}
\title{Data from "Social Networks and the Decision to Insure"}
\format{
A data frame with 1410 rows and 13 variables
\describe{
  \item{address}{Natural village}
  \item{village}{Administrative village}
  \item{takeup_survey}{Whether farmer ended up purchasing insurance. (1 = yes)}
  \item{age}{Household Characteristics - Age}
  \item{agpop}{Household Characteristics - Household Size}
  \item{ricearea_2010}{Area of Rice Production}
  \item{disaster_prob}{Perceived Probability of Disasters Next Year}
  \item{male}{Household Caracteristics: Gender of Household Head (1 = male)}
  \item{default}{"Default option" in experimental format assigned to. (1 = default is to buy, 0 = default is to not buy)}
  \item{intensive}{Whether or not was assigned to "intensive" experimental session (1 = yes)}
  \item{risk_averse}{Risk aversion measurement}
  \item{literacy}{1 = literate, 0 = illiterate}
  \item{pre_takeup_rate}{Takeup rate prior to experiment}
}
}
\source{
Cai, J., De Janvry, A. and Sadoulet, E., 2015. Social networks and the decision to insure. \emph{American Economic Journal: Applied Economics}, 7(2), pp.81-108.
}
\usage{
social_insure
}
\description{
The \code{social_insure} data contains data from Jai, De Janvry, and Saoudlet (2015) on a two-round social network-based experiment on getting farmers to get insurance. See the paper for more details.
}
\details{
This data is used in the \emph{Instrumental Variables} chapter of \emph{The Effect}.
}
\references{
Huntington-Klein. 2021. The Effect: An Introduction to Research Design and Causality. \url{https://theeffectbook.net}.
}
\keyword{datasets}
