% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{abortion}
\alias{abortion}
\title{Data on abortion legalization and sexually transmitted infections}
\format{
A data frame with 19584 rows and 22 variables
\describe{
\item{fip}{State FIPS code}
\item{age}{Age in years}
\item{race}{Race - 1 = white, 2 = black}
\item{year}{Year}
\item{t}{Year but counted on a different scale}
\item{sex}{Sex: 1 = male, 2 = female}
\item{totpop}{Total population}
\item{ir}{Incarcerated Males per 100,000}
\item{crack}{Crack index}
\item{alcohol}{Alcohol consumption per capita}
\item{income}{Real income per capita}
\item{ur}{State unemployment rate}
\item{poverty}{Poverty rate}
\item{repeal}{In a state with an early repeal of abortion prohibition}
\item{acc}{AIDS mortality per 100,000 cumulative in t, t-1, t-2, t-3}
\item{wht}{White Indicator}
\item{male}{Male Indicator}
\item{lnr}{Logged gonnorhea cases per 100,000 in 15-19 year olds}
\item{younger}{From the younger group}
\item{fa}{State-younger interaction}
\item{pi}{Parental involvement law in effect}
\item{bf15}{Is a black female in the 15-19 age group}
}
}
\source{
Cunningham, Scott, and Christopher Cornwell. 2013. “The Long-Run Effect of Abortion on Sexually Transmitted Infections.” American Law and Economics Review 15 (1): 381–407.
}
\usage{
abortion
}
\description{
This data looks at the effect of abortion legalization on the incidence of gonnorhea among 15-19 year olds, as a measure of risky behavior. Treatment is whether abortion is legalized at the time that the eventual 15-19 year olds are born.
}
\details{
This data is used in the \emph{Difference-in-Differences} chapter of \emph{Causal Inference: The Mixtape} by Cunningham.
}
\references{
Cunningham. 2021. Causal Inference: The Mixtape. Yale Press. \url{https://mixtape.scunning.com/index.html}.
}
\keyword{datasets}
