% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simDAG.R
\name{simDAG}
\alias{simDAG}
\title{Simulate a random DAG}
\usage{
simDAG(p, sparsity = NULL, sparsityLim = c(0, 0.8), permute = TRUE)
}
\arguments{
\item{p}{The number of nodes.}

\item{sparsity}{If \code{NULL} (the default), a random edge sparsity
is sampled from the interval provided in \code{sparsityLim}. Otherwise,
the sparsity should be provided as a numeric in [0,1].}

\item{sparsityLim}{A vector of two numerics, both must be in [0,1].}

\item{permute}{If \code{FALSE}, the adjacency matrix will include nodes
in their causal ordering. This is avoided by setting \code{permute = TRUE},
in which case the node order is permuted randomly.}
}
\value{
An adjacency matrix.
}
\description{
Simulates a random directed acyclic graph adjacency (DAG) matrix with
the provided edge sparsity. The edge sparsity is the percentage of edges
that are absent, relative to a fully connected DAG.
}
\examples{
# Simulate a DAG adjacency matrix with 5 nodes
simDAG(5) 

}
