% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caugi.R
\name{.cg_state}
\alias{.cg_state}
\title{Create the state environment for a \code{caugi} (internal)}
\usage{
.cg_state(
  nodes,
  edges,
  ptr,
  built,
  simple,
  class,
  name_index_map,
  index_name_map
)
}
\arguments{
\item{nodes}{A \code{data.table} of nodes with a \code{name} column.}

\item{edges}{A \code{data.table} of edges with \code{from}, \code{edge}, and \code{to} columns.}

\item{ptr}{A pointer to the underlying Rust graph structure
(or \code{NULL} if not built).}

\item{built}{Logical; whether the graph has been built.}

\item{simple}{Logical; whether the graph is simple
(no parallel edges or self-loops).}

\item{class}{Character; one of \code{"UNKNOWN"}, \code{"DAG"}, or \code{"PDAG"}.}

\item{name_index_map}{A \code{fastmap} mapping node names to their zero indexed
indices.}
}
\value{
An environment containing the graph state.
}
\description{
Internal function to create the state environment for a
\code{caugi}. This function is not intended to be used directly by users.
}
\keyword{internal}
