% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trial_ocs.R
\name{trial_ocs}
\alias{trial_ocs}
\title{Calculates the operating characteristics of the cohort trial}
\usage{
trial_ocs(
  iter,
  coresnum = 1,
  save = FALSE,
  path = NULL,
  filename = NULL,
  ret_list = FALSE,
  ret_trials = FALSE,
  plot_ocs = FALSE,
  export = NULL,
  ...
)
}
\arguments{
\item{iter}{Number of program simulations that should be performed}

\item{coresnum}{How many cores should be used for parallel computing}

\item{save}{Indicator whether simulation results should be saved in an Excel file}

\item{path}{Path to which simulation results will be saved; if NULL, then save to current path}

\item{filename}{Filename of saved Excel file with results; if NULL, then name will contain design parameters}

\item{ret_list}{Indicator whether function should return list of results}

\item{ret_trials}{Indicator whether individual trial results should be saved as well}

\item{plot_ocs}{Should OCs stability plots be drawn?}

\item{export}{Should any other variables be exported to the parallel tasks?}

\item{...}{All other design parameters for chosen program}
}
\value{
List containing: Responses and patients on experimental and control arm, total treatment successes and failures and final p-value
}
\description{
Given the trial specific design parameters, performs a number
of simulations of the trial and saves the result in an Excel file
}
\examples{

random <- TRUE

rr_comb1 <- 0.25
prob_comb1_rr <- 1
rr_comb2 <- 0.20
prob_comb2_rr <- 1
rr_plac1 <- 0.10
prob_plac1_rr <- 1
rr_plac2 <- 0.10
prob_plac2_rr <- 1

correlation <- 0.8

cohorts_start <- 2
cohorts_max <- 5
safety_prob <- 0
sharing_type <- "concurrent"
sr_drugs_pos <- 5
sr_first_pos <- FALSE
n_fin <- 100
stage_data <- TRUE
cohort_random <- 0.01
cohort_offset <- 0
cohorts_sim <- Inf
random_type <- "absolute"
missing_prob <- 0.2
cohort_fixed <- 5
hist_lag <- 48
analysis_times <- c(0.5, 0.75, 1)
accrual_type <- "fixed"
accrual_param <- 9
time_trend <- 0.001
composite <- "or"

# Comparison IA1
Bayes_Sup11 <- matrix(nrow = 2, ncol = 2)
Bayes_Sup11[1,] <- c(0.00, 0.95)
Bayes_Sup11[2,] <- c(0.10, 0.80)
# Comparison IA2
Bayes_Sup12 <- matrix(nrow = 2, ncol = 2)
Bayes_Sup12[1,] <- c(0.00, 0.95)
Bayes_Sup12[2,] <- c(0.10, 0.80)
# Comparison IA3
Bayes_Sup13 <- matrix(nrow = 2, ncol = 2)
Bayes_Sup13[1,] <- c(0.00, 0.95)
Bayes_Sup13[2,] <- c(0.10, 0.80)

Bayes_Sup1 <- Bayes_Sup2 <- list(list(Bayes_Sup11), list(Bayes_Sup12), list(Bayes_Sup13))

ocs <- trial_ocs(
n_fin = n_fin, random_type = random_type, composite = composite,
rr_comb1 = rr_comb1, rr_comb2 = rr_comb2, rr_plac1 = rr_plac1, rr_plac2 = rr_plac2,
random = random, prob_comb1_rr = prob_comb1_rr, prob_comb2_rr = prob_comb2_rr,
prob_plac1_rr = prob_plac1_rr, prob_plac2_rr = prob_plac2_rr,
stage_data = stage_data, cohort_random = cohort_random, cohorts_max = cohorts_max,
sr_drugs_pos = sr_drugs_pos, sharing_type = sharing_type, correlation = correlation,
safety_prob = safety_prob, Bayes_Sup1 = Bayes_Sup1, Bayes_Sup2 = Bayes_Sup2,
cohort_offset = cohort_offset, sr_first_pos = sr_first_pos,
missing_prob = missing_prob, cohort_fixed = cohort_fixed, accrual_type = accrual_type,
accrual_param = accrual_param, hist_lag = hist_lag, analysis_times = analysis_times,
time_trend = time_trend, cohorts_start = cohorts_start, cohorts_sim = cohorts_sim,
iter = 2, coresnum = 1, save = FALSE, ret_list = TRUE, plot_ocs = TRUE
)

}
