% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{validate_glm_input}
\alias{validate_glm_input}
\title{Validate Inputs for Catalytic Generalized Linear Models (GLMs)}
\usage{
validate_glm_input(
  formula,
  cat_init,
  tau = NULL,
  tau_seq = NULL,
  tau_0 = NULL,
  parametric_bootstrap_iteration_times = NULL,
  cross_validation_fold_num = NULL,
  risk_estimate_method = NULL,
  discrepancy_method = NULL,
  binomial_joint_theta = FALSE,
  binomial_joint_alpha = FALSE,
  binomial_tau_lower = NULL,
  tau_alpha = NULL,
  tau_gamma = NULL,
  gibbs_iter = NULL,
  gibbs_warmup = NULL,
  coefs_iter = NULL,
  gaussian_variance_alpha = NULL,
  gaussian_variance_beta = NULL
)
}
\arguments{
\item{formula}{A formula object specifying the GLM to be fitted. The left-hand
side of the formula should at least contains the response variable.}

\item{cat_init}{An object of class \code{cat_initialization} generated by
\code{cat_glm_initialization}. It contains model initialization details,
such as the response variable name and the GLM family.}

\item{tau}{A positive numeric value for the tau parameter in the model.
It represents a regularization or scaling factor and must be greater
than zero.}

\item{tau_seq}{A numeric vector specifying a sequence of tau values.
This is used for parameter tuning and must contain positive values.}

\item{tau_0}{A positive numeric value for the initial tau parameter,
which must be greater than zero.}

\item{parametric_bootstrap_iteration_times}{An integer specifying the
number of iterations for the parametric bootstrap method. It must be
greater than zero.}

\item{cross_validation_fold_num}{An integer for the number of folds in
cross-validation. It must be greater than 1 and less than or equal to
the number of observations.}

\item{risk_estimate_method}{A character string specifying the method for
estimating risk, such as "parametric_bootstrap" or other options,
depending on the family of the GLM.}

\item{discrepancy_method}{A character string specifying the method for
calculating discrepancy. The valid options depend on the GLM family
and risk estimation method.}

\item{binomial_joint_theta}{Logical; if TRUE, uses joint theta (theta = 1/tau) in Binomial models.}

\item{binomial_joint_alpha}{Logical; if TRUE, uses joint alpha (adaptive tau_alpha) in Binomial models.}

\item{binomial_tau_lower}{A positive numeric value specifying the lower
bound for tau in binomial GLMs. It must be greater than zero.}

\item{tau_alpha}{A positive numeric value for the tau alpha parameter.}

\item{tau_gamma}{A positive numeric value for the tau gamma parameter.}

\item{gibbs_iter}{An integer for the number of Gibbs iterations in the
sampling process. It must be greater than zero.}

\item{gibbs_warmup}{An integer for the number of warm-up iterations in the
Gibbs sampling. It must be positive and less than the total number
of iterations.}

\item{coefs_iter}{An integer specifying the number of iterations for the
coefficient update in the Gibbs sampling. It must be positive.}

\item{gaussian_variance_alpha}{The shape parameter for the inverse-gamma prior on
variance if the variance is unknown in Gaussian models. It must be positive.}

\item{gaussian_variance_beta}{The scale parameter for the inverse-gamma prior on
variance if the variance is unknown in Gaussian models. It must be positive.}
}
\value{
Returns nothing if all checks pass; otherwise, raises an error or warning.
}
\description{
This function validates the input parameters for initializing a catalytic Generalized
Linear Models (GLMs). It ensures that the provided model formula, family, and
additional parameters are suitable for further analysis. The function performs
various checks on the input values to confirm they meet expected criteria.
}
\details{
This function performs several checks to ensure the validity of the input
parameters:
\itemize{
\item Ensures that \code{tau}, \code{tau_0}, \code{parametric_bootstrap_iteration_times},
\code{binomial_tau_lower}, \code{tau_alpha}, \code{tau_gamma}, \code{gibbs_iter},
\code{gibbs_warmup}, and \code{coefs_iter} are positive values.
\item Verifies that \code{cat_init} is an object generated by
\code{cat_glm_initialization}.
\item Checks that the \code{formula} response name matches the response name
used in the \code{cat_init} object.
\item Verifies that \code{risk_estimate_method} and \code{discrepancy_method} are
compatible with the GLM family and that no invalid combinations are
used.
\item Warns if the dataset size is too large for the specified risk
estimation method.
If any of these conditions are not met, the function raises an error or warning to guide the user.
}
}
