% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prints.R
\name{print.cat_initialization}
\alias{print.cat_initialization}
\title{Print Summary for Catalytic Initialization Model}
\usage{
\method{print}{cat_initialization}(x, show_data = TRUE, detail = TRUE, ...)
}
\arguments{
\item{x}{A catalytic initialization model object containing formula, family, data dimensions, and sampling details.}

\item{show_data}{Logical, default \code{TRUE}. If \code{TRUE}, previews the head of both observation and synthetic data (up to the first 10 columns).}

\item{detail}{Logical, default \code{TRUE}. If \code{TRUE}, adds guidance for interpreting the output.}

\item{...}{Additional parameters to pass to other functions.}
}
\value{
Invisibly returns the \code{x} object.
}
\description{
This function provides a comprehensive summary of a catalytic initialization model object (\code{cat_init}),
including formula details, data dimensions, and sample data previews.
}
\details{
The function provides a detailed overview of the initialization process for the \code{cat_initialization} model,
including:
\itemize{
\item The formula used in the model.
\item The type of model (if Gaussian, the known or unknown variance is specified).
\item The family of the Generalized Linear Model (GLM), along with the associated link function.
\item The dimensions of the observation and synthetic data sets, with an option to display the first few rows.
\item Information on the data generation process if available.
}

The \code{show_data} parameter controls whether the first few rows of the data are printed, while the \code{detail}
parameter controls whether additional help for interpreting the printed output is displayed.
}
