% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prints.R
\name{extract_tau_seq}
\alias{extract_tau_seq}
\title{Extract and Format Sequence of Tau Values}
\usage{
extract_tau_seq(x, digit = 3)
}
\arguments{
\item{x}{A model object generated from \code{catalytic} that containing a sequence of tau values.}

\item{digit}{An integer specifying the number of decimal places to which tau values should
be rounded. Default is 3.}
}
\value{
A character string representing the rounded tau values, formatted for readability.
}
\description{
This function retrieves the sequence of tau values from a \code{x} object, rounds each
value to the specified number of decimal places, and formats the output as a concise string.
If the sequence contains more than 10 values, only the first 3 and last 3 values are shown,
with ellipsis ("...") in between.
}
