% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_function}
\alias{get_function}
\title{Get A Function}
\usage{
get_function(sc, fn, database = NULL)
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{fn}{\code{character(1)}. The name of the function.}

\item{database}{\code{character(1)}. The name of the database for which the
functions should be listed (default: \code{NULL}).}
}
\value{
A \code{spark_jobj} which includes the class name, database, description, whether
it is temporary and the name of the function.
}
\description{
Get the function with the specified name.
}
\details{
If you are trying to get an in-built function then use the unqualified name
and pass \code{NULL} as the \code{database} name.
}
\examples{
\dontrun{
sc <- sparklyr::spark_connect(master = "local")
get_function(sc = sc, fn = "Not")
}

}
\seealso{
\code{\link[=function_exists]{function_exists()}}, \code{\link[=list_functions]{list_functions()}}
}
