% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caretPredict.R
\name{caretTrain}
\alias{caretTrain}
\title{Wrapper to train caret models}
\usage{
caretTrain(local_args, global_args, continue_on_fail = FALSE, trim = TRUE)
}
\arguments{
\item{local_args}{A list of arguments to pass to the `train` function.}

\item{global_args}{A list of arguments to pass to the `train` function.}

\item{continue_on_fail}{A logical indicating whether to continue if the `train` function fails.
If `TRUE`, the function will return `NULL` if the `train` function fails.}

\item{trim}{A logical indicating whether to trim the output model.
If `TRUE`, the function will remove some elements that are not needed from the output model.}
}
\value{
The output of the `train` function.
}
\description{
This function is a wrapper around the `train` function from the `caret` package.
It allows for the passing of local and global arguments to the `train` function.
It also allows for the option to continue on fail, and to trim the output model.
Trimming the model removes components that are not needed for stacking, to save
memory and speed up the stacking process. It also converts preds to a data.table.
Its an internal function for use with caretList.
}
\keyword{internal}
