% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_fmt_fun.R
\name{alias_as_fmt_fun}
\alias{alias_as_fmt_fun}
\title{Convert Alias to Function}
\usage{
alias_as_fmt_fun(x, variable, stat_name)
}
\arguments{
\item{x}{(\code{integer}, \code{string}, or \code{function})\cr
a non-negative integer, string alias, or function}

\item{variable}{(\code{character})\cr the variable whose statistic is to be formatted}

\item{stat_name}{(\code{character})\cr the name of the statistic that is to be formatted}
}
\value{
a function
}
\description{
Accepted aliases are non-negative integers and strings.

The integers are converted to functions that round the statistics
to the number of decimal places to match the integer.

The formatting strings come in the form \code{"xx"}, \code{"xx.x"}, \code{"xx.x\%"}, etc.
The number of \code{x}s that appear after the decimal place indicate the number of
decimal places the statistics will be rounded to.
The number of \code{x}s that appear before the decimal place indicate the leading
spaces that are added to the result.
If the string ends in \code{"\%"}, results are scaled by 100 before rounding.
}
\examples{
alias_as_fmt_fun(1)
alias_as_fmt_fun("xx.x")
}
