% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odd_shapes.R
\name{make_klink_curvycycle}
\alias{make_klink_curvycycle}
\title{Generate Multiple Interlocked curvycycle in High-Dimensional Space}
\usage{
make_klink_curvycycle(n = c(200, 100), p = 4, k = 2, offset = 0.5)
}
\arguments{
\item{n}{An integer vector of length \eqn{k} giving the number of points
in each curvycycle. Default is \code{c(200, 100)}.}

\item{p}{Integer, the dimensionality of the embedding space. Must be
at least 3. Default is \code{4}.}

\item{k}{Integer, the number of curvycycle to generate. Default is \code{2}.}

\item{offset}{Numeric, the amount of positional shift applied to each
curvycycle along the second coordinate axis to prevent complete overlap.
Default is \code{0.5}.}
}
\value{
A data frame (or tibble, depending on \code{gen_multicluster()})
  containing the generated points and cluster assignments.
}
\description{
This function generates \eqn{k} interlocked circular clusters in a
\eqn{p}-dimensional space. The curvycycle are constructed using
\code{gen_multicluster()}, with each curvycycle positioned in a different
coordinate plane and slightly offset so that they interlock with a
central curvycycle (hub-like structure).
}
\examples{
# Generate two interlocked curvycycle in 4-D
twolink_curvycycle <- make_klink_curvycycle()
}
