% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_vcov.R
\name{vcov.felm}
\alias{vcov.felm}
\title{Covariance matrix for LMs}
\usage{
\method{vcov}{felm}(
  object,
  type = c("hessian", "outer.product", "sandwich", "clustered"),
  ...
)
}
\arguments{
\item{object}{an object of class \code{"felm"}.}

\item{type}{the type of covariance estimate required. \code{"hessian"} refers
to the inverse of the negative expected hessian after convergence and is the
default option. \code{"outer.product"} is the outer-product-of-the-gradient
estimator. \code{"sandwich"} is the sandwich estimator (sometimes also
referred as robust estimator), and \code{"clustered"} computes a clustered
covariance matrix given some cluster variables.}

\item{...}{additional arguments.}
}
\value{
A named matrix of covariance estimates.
}
\description{
Covariance matrix for the estimator of the structural parameters
from objects returned by \code{\link{felm}}. The covariance is computed
from the hessian, the scores, or a combination of both after convergence.
}
\examples{
# same as the example in felm but extracting the covariance matrix
mod <- felm(log(mpg) ~ log(wt) | cyl | am, mtcars)
vcov(mod, type = "clustered")

}
\seealso{
\code{\link{felm}}
}
