% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daily_behaviour.R
\name{get_pedometer_wear_time}
\alias{get_pedometer_wear_time}
\title{Compute pedometer wear time in decimal hours for a given day.}
\usage{
get_pedometer_wear_time(time_on = NA, time_off = NA, non_wear_time = NA)
}
\arguments{
\item{time_on}{A character vector representing the time (in 12- or 24-hour clock format) when the pedometer was first worn on a given day.}

\item{time_off}{A character vector representing the time (in 12- or 24-hour clock format) when the pedometer was removed at the end of a given
day.}

\item{non_wear_time}{A numeric vector representing the total time (in minutes) the pedometer was not worn during waking hours on a given day.}
}
\value{
Returns a numeric vector with values >= 0 (if valid) or NA (if not valid).
}
\description{
This function computes pedometer wear time in decimal hours for a given day (e.g., \code{wear_time1}). This variable is used to compute the \code{step_average}
variable and the step score (\code{step_score}).
}
\details{
Other \code{capl} functions called by this function include: \code{\link[=get_24_hour_clock]{get_24_hour_clock()}} and \code{\link[=validate_number]{validate_number()}}.
}
\examples{
get_pedometer_wear_time(
  time_on = c("6:23", "5:50 am", NA),
  time_off = c("21:37", "9:17pm", ""),
  c(60, 90, 0)
)

# [1] 14.23 13.95    NA

}
