% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motivation_and_confidence.R
\name{get_intrinsic_motivation_score}
\alias{get_intrinsic_motivation_score}
\title{Compute an intrinsic motivation score.}
\usage{
get_intrinsic_motivation_score(
  why_active1 = NA,
  why_active2 = NA,
  why_active3 = NA
)
}
\arguments{
\item{why_active1}{A numeric (integer) vector representing a response to BREQ item 1 (valid values are integers between 1 and 5).}

\item{why_active2}{a numeric (integer) vector representing a response to BREQ item 2 (valid values are integers between 1 and 5).}

\item{why_active3}{a numeric (integer) vector representing a response to BREQ item 3 (valid values are integers between 1 and 5).}
}
\value{
Returns a numeric vector with values between 1.5 and 7.5 (if valid) or NA (if not valid).
}
\description{
This function computes an intrinsic motivation score (\code{intrinsic_motivation_score}) for responses to items 1-3 of the the Behavioral Regulation in
Exercise Questionnaire (BREQ) as they appear in \href{https://www.capl-eclp.ca/wp-content/uploads/2018/02/CAPL-2-questionnaire.pdf}{the CAPL-2 Questionnaire}. This score is used to compute the motivation and confidence domain score
(\code{mc_score}).
}
\details{
Other \code{capl} functions called by this function include: \code{\link[=validate_scale]{validate_scale()}}.

Valid values (integers between 1 and 5) represent the following responses:
\itemize{
\item 1 = Not true for me
\item 2 = Not really true for me
\item 3 = Sometimes true for me
\item 4 = Often true for me
\item 5 = Very true for me
}
}
\examples{
get_intrinsic_motivation_score(
  why_active1 = c(4, 3, 6, 5, "2"),
  why_active2 = c(1:5),
  why_active3 = c(1, 5, 4, 3, 3)
)

# [1]  3  5 NA  6  5

}
