% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_canradar_summary_file.R
\name{create_canradar_summary_file}
\alias{create_canradar_summary_file}
\title{Compute summary statistics from 5 years age-group cancer registry data}
\usage{
create_canradar_summary_file(
  filename.in,
  filename.out,
  ncan.min = 5,
  py.min = 100,
  include.by.cob.stat = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{filename.in}{file path, the file containing the 5 years age counts of cancers stratified per cancer type, sex and country of birth}

\item{filename.out}{file path, the file where summary .xlsx file will be save}

\item{ncan.min}{integer, the minimum number of cancer per age group o be displayed}

\item{py.min}{integer, the minimum number of person-years per age group to be considered during the aggregation step (default is 100)}

\item{include.by.cob.stat}{logical, (TRUE by default) should the statistic per country-of-birth  be computed and included in the output file.}

\item{verbose}{logical, shall progress message be printed}
}
\value{
a .xlsx with all the summary statistics needed for Cancer RADAR project to be transmitted to project PIs.
}
\description{
Compute summary statistics from 5 years age-group cancer registry data
}
\examples{
\donttest{
  ## Update file.in with the path to the input file containing your registry data
  ## (e.g. file.filled <- "cancerRADAR_input.xlsx")
  file.in <- system.file("extdata", "ex_cancerRADAR_input_filled.xlsx", package = "cancerradarr")
  file.out <- 'cancerRADAR_input.xlsx'
  ## for cancer radar data submission, we advise to use the parameter ncan.min = 5 and
  ## include.by.cob.stat = TRUE
  create_canradar_summary_file(file.in, file.out, ncan.min = 20, include.by.cob.stat = FALSE)
  ## remove the file to pass package computation tests
  unlink(file.out)
}
}
\concept{main}
