% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aya_class.R
\name{aya_class}
\alias{aya_class}
\title{Adolescent and young adult cancer classification}
\usage{
aya_class(
  histology,
  site,
  behaviour,
  method = "Barr 2020",
  depth = 1,
  verbose = FALSE
)
}
\arguments{
\item{histology}{Histology code of the cancer.}

\item{site}{Site (aka topography) code of the cancer.}

\item{behaviour}{Behaviour code of the cancer.}

\item{method}{Method used for the diagnosis classification of the cancer.
Default is \code{"Barr 2020"}.
Can be one of \code{"Barr 2020"}, \code{"SEER v2006"},
\code{"SEER v2020"}, \code{"SEER-WHO v2008"}.}

\item{depth}{Depth level of the classification hierarchy to be determined.
If set to \code{99}, will return the SEER grouping.}

\item{verbose}{Logical value to print messages to the console if unable to
classify or duplicates found. Default is \code{FALSE}.}
}
\value{
Returns the diagnostic classification of the cancer based on the specified
method and depth level.
}
\description{
This function classifies the type of adolescent and young adult cancer cases
based on the histology, site, and behaviour codes of the cancer. It uses the
International Classification of Diseases for Oncology (ICD-O), 3rd edition
codes to determine the classification. The function returns a value is based
on the method specified and the depth level of the classification hierarchy
to be determined.
}
\examples{
# First position in the classification hierarchy
aya_class("9020", "C50.1", "3", method = "Barr 2020", depth = 1)

# Second position in the classification hierarchy
aya_class("9020", "C50.1", "3", method = "Barr 2020", depth = 2)

# Third position in the classification hierarchy
aya_class(9020, "C50.1", "3", method = "Barr 2020", depth = 3)
}
