% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand-abbrev.R
\name{expand_state}
\alias{expand_state}
\title{Expand US state names}
\usage{
expand_state(abb)
}
\arguments{
\item{abb}{A abb US state name character vector (e.g., "Vermont").}
}
\value{
The 2-letter USPS abbreviation of for state names (e.g., "VT").
}
\description{
This function is used to first normalize an \code{abb} and then call
\code{\link[=expand_abbrev]{expand_abbrev()}} using \link{valid_state} and \link{valid_name} as the \code{abb} and \code{rep}
arguments.
}
\examples{
expand_state(abb = state.abb)
expand_state(abb = c("nm", "fr"))
}
\seealso{
Other geographic normalization functions: 
\code{\link{abbrev_full}()},
\code{\link{abbrev_state}()},
\code{\link{check_city}()},
\code{\link{expand_abbrev}()},
\code{\link{fetch_city}()},
\code{\link{normal_address}()},
\code{\link{normal_city}()},
\code{\link{normal_state}()},
\code{\link{normal_zip}()},
\code{\link{str_normal}()}
}
\concept{geographic normalization functions}
