% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components-generated.R
\name{calcite_stepper}
\alias{calcite_stepper}
\title{Create a Stepper component}
\usage{
calcite_stepper(...)
}
\arguments{
\item{...}{named attributes passed to \code{htmltools::tag()}}
}
\value{
an object of class \code{calcite_component} which is a subclass of \code{shiny.tag}
}
\description{
Create a Stepper component
}
\details{
\subsection{Properties}{

The following properties are provided by this component:\tabular{lllll}{
   Name \tab Attribute \tab Description \tab Values \tab Reflects to Attribute \cr
   icon \tab icon \tab When \code{true}, displays a status icon in the \code{calcite-stepper-item} heading. \tab boolean \tab TRUE \cr
   layout \tab layout \tab Defines the layout of the component. \tab "horizontal" | "horizontal-single" | "vertical" \tab TRUE \cr
   messageOverrides \tab NA \tab Use this property to override individual strings used by the component. \tab Check API reference \tab FALSE \cr
   numbered \tab numbered \tab When \code{true}, displays the step number in the \code{calcite-stepper-item} heading. \tab boolean \tab TRUE \cr
   numberingSystem \tab numbering-system \tab Specifies the Unicode numeral system used by the component for localization. \tab "arab" | "arabext" | "latn" \tab TRUE \cr
   scale \tab scale \tab Specifies the size of the component. \tab "l" | "m" | "s" \tab TRUE \cr
   selectedItem \tab NA \tab Specifies the component's selected item. \tab HTMLCalciteStepperItemElement \tab FALSE \cr
}

}

\subsection{Events}{

The following events are observed by shiny:\tabular{ll}{
   Event \tab Description \cr
   calciteStepperChange \tab Fires when the active \code{calcite-stepper-item} changes. \cr
   calciteStepperItemChange \tab Fires when the active \code{calcite-stepper-item} changes. \cr
}

}

\subsection{Slots}{

The following slots are provided by this component:\tabular{ll}{
   Slot \tab Description \cr
   Default (unnamed) \tab A slot for adding \code{calcite-stepper-item} elements. \cr
}

}
}
\examples{
calcite_stepper()
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/stepper/}{Official Documentation}
}
