% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators_weights.R
\name{calculateWeightsKettenring}
\alias{calculateWeightsKettenring}
\title{Calculate composite weights using GCCA}
\usage{
calculateWeightsKettenring(
  .S              = args_default()$.S, 
  .csem_model     = args_default()$.csem_model,   
  .approach_gcca  = args_default()$.approach_gcca
  )
}
\arguments{
\item{.S}{The (K x K) empirical indicator correlation matrix.}

\item{.csem_model}{A (possibly incomplete) \link{cSEMModel}-list.}

\item{.approach_gcca}{Character string. The Kettenring approach to use for GCCA. One of
"\emph{SUMCORR}", "\emph{MAXVAR}", "\emph{SSQCORR}", "\emph{MINVAR}" or "\emph{GENVAR}". Defaults to
"\emph{SUMCORR}".}
}
\value{
A named list. J stands for the number of constructs and K for the number
of indicators.
\describe{
\item{\verb{$W}}{A (J x K) matrix of estimated weights.}
\item{\verb{$E}}{\code{NULL}}
\item{\verb{$Modes}}{The GCCA mode used for the estimation.}
\item{\verb{$Conv_status}}{The convergence status. \code{TRUE} if the algorithm has converged
and \code{FALSE} otherwise. For \code{.approach_gcca = "MINVAR"} or \code{.approach_gcca = "MAXVAR"}
the convergence status is \code{NULL} since both are closed-form estimators.}
\item{\verb{$Iterations}}{The number of iterations required. 0 for
\code{.approach_gcca = "MINVAR"} or \code{.approach_gcca = "MAXVAR"}}
}
}
\description{
Calculates composite weights according to one of the the five criteria
"\emph{SUMCORR}", "\emph{MAXVAR}", "\emph{SSQCORR}", "\emph{MINVAR}", and "\emph{GENVAR}"
suggested by \insertCite{Kettenring1971;textual}{cSEM}.
}
\references{
\insertAllCited{}
}
