% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_datasets.R
\docType{data}
\name{Benitezetal2020}
\alias{Benitezetal2020}
\title{Data: Benitezetal2020}
\format{
An object of class \code{data.frame} with 300 rows and 22 columns.
}
\source{
The dataset is provided as supplementary material by \insertCite{Benitez2020;textual}{cSEM}.
}
\usage{
Benitezetal2020
}
\description{
A data frame containing 22 variables with 300 observations.
}
\details{
The simulated data contains variables about the social executive and employee behavior.
Moreover, it contains variables about the social media capability and business performance.
The dataset was used as an illustrative example in \insertCite{Benitez2020;textual}{cSEM}.
}
\examples{
#============================================================================
# Example is taken from Benitez et al. (2020)
#============================================================================
model_Benitez <-"
# Reflective measurement models# Reflective measurement models
SEXB =~ SEXB1 + SEXB2 + SEXB3 +SEXB4
SEMB =~ SEMB1 + SEMB2 + SEMB3 + SEMB4

# Composite models
SMC <~ SMC1 + SMC2 + SMC3 + SMC4
BPP <~ BPP1 + BPP2 + BPP3 + BPP4 + BPP5

# Control variables
FS<~ FirmSize
Ind <~ Industry1 + Industry2 + Industry3

# Structural model
SMC ~ SEXB + SEMB 
BPP ~ SMC + Ind + FS
"

out <- csem(.data = Benitezetal2020, .model = model_Benitez,
            .PLS_weight_scheme_inner = 'factorial',
            .tolerance = 1e-06)

}
\references{
\insertAllCited{}
}
\keyword{datasets}
