% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sim_iw}
\alias{sim_iw}
\title{Generate Inverse-Wishart Random Matrix}
\usage{
sim_iw(mat_scale, shape)
}
\arguments{
\item{mat_scale}{Scale matrix}

\item{shape}{Shape}
}
\value{
One k x k matrix following IW distribution
}
\description{
This function samples one matrix IW matrix.
}
\details{
Consider \eqn{\Sigma \sim IW(\Psi, \nu)}.
\enumerate{
\item Upper triangular Bartlett decomposition: k x k matrix \eqn{Q = [q_{ij}]} upper triangular with
\enumerate{
\item \eqn{q_{ii}^2 \chi_{\nu - i + 1}^2}
\item \eqn{q_{ij} \sim N(0, 1)} with i < j (upper triangular)
}
\item Lower triangular Cholesky decomposition: \eqn{\Psi = L L^T}
\item \eqn{A = L (Q^{-1})^T}
\item \eqn{\Sigma = A A^T \sim IW(\Psi, \nu)}
}
}
