% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{post_normal}
\alias{post_normal}
\title{Posterior Draw from a Normal Distribution}
\usage{
post_normal(y, x, sigma_i, a_prior, v_i_prior)
}
\arguments{
\item{y}{a \eqn{K \times T} matrix of endogenous variables.}

\item{x}{an \eqn{M \times T} matrix of explanatory variables.}

\item{sigma_i}{the inverse of the \eqn{K \times K} variance-covariance matrix.}

\item{a_prior}{a \eqn{KM \times 1} numeric vector of prior means.}

\item{v_i_prior}{the inverse of the \eqn{KM \times KM} prior covariance matrix.}
}
\value{
A vector.
}
\description{
Produces a draw of coefficients from a normal posterior density.
}
\details{
The function produces a vectorised posterior draw \eqn{a} of the
\eqn{K \times M} coefficient matrix \eqn{A} for the model
\deqn{y_{t} = A x_{t} + u_{t},}
where \eqn{y_{t}} is a K-dimensional vector of endogenous variables,
\eqn{x_{t}} is an M-dimensional vector of explanatory variabes
and the error term is \eqn{u_t \sim \Sigma}.

For a given prior mean vector \eqn{\underline{a}} and prior covariance matrix \eqn{\underline{V}}
the posterior covariance matrix is obtained by
\deqn{\overline{V} = \left[ \underline{V}^{-1} + \left(X X^{\prime} \otimes \Sigma^{-1} \right) \right]^{-1}}
and the posterior mean by
\deqn{\overline{a} = \overline{V} \left[ \underline{V}^{-1} \underline{a} + vec(\Sigma^{-1} Y X^{\prime}) \right],}
where \eqn{Y} is a \eqn{K \times T} matrix of the endogenous variables and \eqn{X} is an \eqn{M \times T} matrix of
the explanatory variables.
}
\examples{

# Load data
data("e1")
data <- diff(log(e1))

# Generate model data
temp <- gen_var(data, p = 2, deterministic = "const")
y <- t(temp$data$Y)
x <- t(temp$data$Z)
k <- nrow(y)
tt <- ncol(y)
m <- k * nrow(x)

# Priors
a_mu_prior <- matrix(0, m)
a_v_i_prior <- diag(0.1, m)

# Initial value of inverse Sigma
sigma_i <- solve(tcrossprod(y) / tt)

# Draw parameters
a <- post_normal(y = y, x = x, sigma_i = sigma_i,
                 a_prior = a_mu_prior, v_i_prior = a_v_i_prior)

}
\references{
Lütkepohl, H. (2006). \emph{New introduction to multiple time series analysis} (2nd ed.). Berlin: Springer.
}
